/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners;

import com.aetherteam.aether.event.hooks.DimensionHooks;
import com.aetherteam.aetherfabric.events.BlockEvents;
import com.aetherteam.aetherfabric.events.CancellableCallback;
import com.aetherteam.aetherfabric.events.EntityEvents;
import com.aetherteam.aetherfabric.events.LevelEvents;
import com.aetherteam.aetherfabric.events.PlayerTickEvents;
import java.util.function.Function;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

public class DimensionListener {
    public static void listen() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> DimensionListener.onPlayerLogin((class_1657)handler.method_32311()));
        UseBlockCallback.EVENT.register(DimensionListener::onInteractWithPortalFrame);
        BlockEvents.NEIGHBOR_UPDATE.register((level, pos, state, notifiedSides, forceRedstoneUpdate, isCancelled) -> DimensionListener.onWaterExistsInsidePortalFrame((class_1936)level, pos, isCancelled));
        LevelEvents.AFTER.register(DimensionListener::onWorldTick);
        EntityEvents.BEFORE_DIMENSION_CHANGE.register(DimensionListener::onEntityTravelToDimension);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> DimensionListener.onPlayerChangedDimension((class_1657)player));
        PlayerTickEvents.AFTER.register(DimensionListener::onPlayerTraveling);
        ServerWorldEvents.LOAD.register((server, world) -> DimensionListener.onWorldLoad((class_1936)world));
        EntitySleepEvents.ALLOW_SLEEPING.register((player, sleepingPos) -> DimensionListener.onTriedToSleep(player));
    }

    public static void onPlayerLogin(class_1657 player) {
        DimensionHooks.startInAether(player);
    }

    public static class_1269 onInteractWithPortalFrame(class_1657 player, class_1937 level, class_1268 interactionHand, class_3965 hitResult) {
        class_2338 blockPos = hitResult.method_17777();
        class_2350 direction = hitResult.method_17780();
        class_1799 itemStack = player.method_5998(interactionHand);
        return DimensionHooks.createPortal(player, level, blockPos, direction, itemStack, interactionHand);
    }

    public static void onWaterExistsInsidePortalFrame(class_1936 level, class_2338 blockPos, CancellableCallback isCancelled) {
        class_3610 fluidState;
        class_2680 blockState = level.method_8320(blockPos);
        if (DimensionHooks.detectWaterInFrame(level, blockPos, blockState, fluidState = level.method_8316(blockPos))) {
            isCancelled.setCanceled(true);
        }
    }

    public static void onWorldTick(class_1937 level) {
        if (!level.method_8608()) {
            DimensionHooks.tickTime(level);
            DimensionHooks.checkEternalDayConfig(level);
        }
    }

    public static void onEntityTravelToDimension(class_1297 entity, class_5321<class_1937> dimension) {
        DimensionHooks.dimensionTravel(entity, dimension);
        DimensionHooks.removePlayerAerbunny(entity);
    }

    public static void onPlayerChangedDimension(class_1657 player) {
        DimensionHooks.remountPlayerAerbunny(player);
    }

    public static void onPlayerTraveling(class_1657 player) {
        DimensionHooks.travelling(player);
    }

    public static void onWorldLoad(class_1936 level) {
        DimensionHooks.initializeLevelData(level);
    }

    public static void onSleepFinish(class_1936 level, MutableLong newTime, Function<Long, Boolean> consumer) {
        Long time = DimensionHooks.finishSleep(level, newTime);
        if (time != null) {
            consumer.apply(time);
        }
    }

    @Nullable
    public static class_1657.class_1658 onTriedToSleep(class_1657 player) {
        if (DimensionHooks.isEternalDay(player)) {
            return class_1657.class_1658.field_7529;
        }
        return null;
    }
}

